// Copy to clipboard for HEX buttons
document.addEventListener('click', function(e){
  if(e.target.matches('button[data-copy]')){
    const text = e.target.getAttribute('data-copy');
    navigator.clipboard.writeText(text).then(()=>{
      const original = e.target.textContent;
      e.target.textContent = 'Copied!';
      setTimeout(()=> e.target.textContent = original, 1200);
    }).catch(()=> alert('Copy failed — your browser may block clipboard access.'));
  }
});

// Download CSS variables for current palette
document.getElementById('download-css')?.addEventListener('click', ()=>{
  const cards = Array.from(document.querySelectorAll('.card'));
  if(cards.length === 0){ alert('No colors found'); return; }
  let css = ':root {\n';
  cards.forEach((card, i)=>{
    const hexLabel = card.querySelector('.code')?.textContent?.trim() || '';
    css += `  --color-${i+1}: ${hexLabel};\n`;
  });
  css += '}\n';
  const blob = new Blob([css], {type: 'text/css'});
  const url = URL.createObjectURL(blob);
  const a = document.createElement('a');
  a.href = url;
  a.download = 'palette.css';
  document.body.appendChild(a);
  a.click();
  a.remove();
  URL.revokeObjectURL(url);
});
